/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.python.core.Py;
import org.python.core.io.RawIOBase;
import org.python.modules.posix.PosixModule;

public class StreamIO
extends RawIOBase {
    private ReadableByteChannel readChannel;
    private WritableByteChannel writeChannel;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean closefd;

    public StreamIO(ReadableByteChannel readableByteChannel, boolean bl) {
        this.readChannel = readableByteChannel;
        this.closefd = bl;
    }

    public StreamIO(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, true);
    }

    public StreamIO(WritableByteChannel writableByteChannel, boolean bl) {
        this.writeChannel = writableByteChannel;
        this.closefd = bl;
    }

    public StreamIO(WritableByteChannel writableByteChannel) {
        this(writableByteChannel, true);
    }

    public StreamIO(InputStream inputStream, boolean bl) {
        this(Channels.newChannel(inputStream), bl);
        this.inputStream = inputStream;
    }

    public StreamIO(OutputStream outputStream, boolean bl) {
        this(Channels.newChannel(outputStream), bl);
        this.outputStream = outputStream;
    }

    public int readinto(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.readChannel.read(byteBuffer);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public int write(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.writeChannel.write(byteBuffer);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void flush() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        if (this.closefd) {
            try {
                if (this.readChannel != null) {
                    this.readChannel.close();
                    if (this.writeChannel != null && this.readChannel != this.writeChannel) {
                        this.writeChannel.close();
                    }
                } else {
                    this.writeChannel.close();
                }
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDescriptor getInputFileDescriptor(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        if (inputStream instanceof FileInputStream) {
            return ((FileInputStream)inputStream).getFD();
        }
        if (inputStream instanceof FilterInputStream) {
            Field field = null;
            try {
                field = FilterInputStream.class.getDeclaredField("in");
                field.setAccessible(true);
                FileDescriptor fileDescriptor = StreamIO.getInputFileDescriptor((InputStream)field.get(inputStream));
                return fileDescriptor;
            }
            catch (Exception exception) {
            }
            finally {
                if (field != null && field.isAccessible()) {
                    field.setAccessible(false);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDescriptor getOutputFileDescriptor(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return null;
        }
        if (outputStream instanceof FileOutputStream) {
            return ((FileOutputStream)outputStream).getFD();
        }
        if (outputStream instanceof FilterOutputStream) {
            Field field = null;
            try {
                field = FilterOutputStream.class.getDeclaredField("out");
                field.setAccessible(true);
                FileDescriptor fileDescriptor = StreamIO.getOutputFileDescriptor((OutputStream)field.get(outputStream));
                return fileDescriptor;
            }
            catch (Exception exception) {
            }
            finally {
                if (field != null && field.isAccessible()) {
                    field.setAccessible(false);
                }
            }
        }
        return null;
    }

    public boolean isatty() {
        FileDescriptor fileDescriptor;
        this.checkClosed();
        try {
            fileDescriptor = StreamIO.getInputFileDescriptor(this.inputStream);
            if (fileDescriptor == null && (fileDescriptor = StreamIO.getOutputFileDescriptor(this.outputStream)) == null) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return PosixModule.getPOSIX().isatty(fileDescriptor);
    }

    public boolean readable() {
        return this.readChannel != null;
    }

    public boolean writable() {
        return this.writeChannel != null;
    }

    public OutputStream asOutputStream() {
        if (this.writable()) {
            if (this.outputStream == null) {
                return Channels.newOutputStream(this.writeChannel);
            }
            return this.outputStream;
        }
        return super.asOutputStream();
    }

    public InputStream asInputStream() {
        if (this.readable()) {
            if (this.inputStream == null) {
                return Channels.newInputStream(this.readChannel);
            }
            return this.inputStream;
        }
        return super.asInputStream();
    }

    public Channel getChannel() {
        return this.readable() ? this.readChannel : this.writeChannel;
    }
}

